/*
 * Copyright (c) 2008 Lu, Chao-Ming (Tetralet).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

void pid_access_env (pid_t pid, const gchar *name, gchar** oldvalue, gchar* newvalue)
{
	gchar *path;
    gchar *environ;
    gsize length;
    GError* error = NULL;

	path = g_strdup_printf("/proc/%d/environ", pid);
//	g_debug ("environ file =%s\n", path);

	// FIXME: environ need be freed when no longer needed or not?
	if (g_file_get_contents (path, &environ, &length, &error))
	{
		FILE *envfile = fopen(path, "w");
//		FILE *envfile = fopen("/tmp/environ", "w");
		gchar *check;
		check = g_strdup_printf("%s=", name);
		gboolean got_env = FALSE;

		gsize read_length=0;
		while (read_length<length)
		{
//			g_debug("ENV: %s\n",environ+read_length);
			if ((! got_env) && g_str_has_prefix(environ+read_length, check))
			{
				// if oldvale is set, don't touch oldvalue
				if (*oldvalue==NULL)
				{
					*oldvalue = g_strdup(environ+read_length+strlen(check));
					g_debug("Got %s=%s\n", name, *oldvalue);
				}
				else
				{
					g_debug("We won't touch LC_ALL!");
				}
				// change the LC_ALL env
				got_env = TRUE;
				g_debug ("kill?");
				fprintf(envfile, "%s=%s", name, newvalue);
				g_debug ("kill!");
				fputc(0, envfile);
			}
			else
			{
				// write new environ
				fputs(environ+read_length, envfile);
				fputc(0, envfile);
			}
			read_length+=(strlen(environ+read_length)+1);
		}
		if (! got_env)
		{
			// if the value is not been set at all, write a new value in it
			g_debug("Can not find LC_ALL!");
			fprintf(envfile, "%s=%s", name, newvalue);
			fputc(0, envfile);
		}
		fclose(envfile);
		g_free(check);
	}
	else
	{
		g_debug("Warnning: can not got the environ from %s.", g_strdup_printf("/proc/%d/environ", pid));
		g_error_free (error);
	}

	g_free(environ);
	g_free(path);
}

