/*
 * Copyright (c) 2008 Lu, Chao-Ming (Tetralet).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "main.h"

// For command line options.
gchar *command_line=NULL;
gchar **parameter=NULL;
gchar *profile=NULL;

GtkWidget *window;
GtkWidget *notebook;
//#ifdef HINTS
extern GtkWidget *current_vtebox;
extern gint force_resize_window;
//#endif

int main( int   argc,
	  char *argv[] )
{
	setlocale(LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (PACKAGE, "UTF-8");
	textdomain (PACKAGE);

	// deal the command line optins
	command_option(&argc, argv);

	// init the gtk+2 engine
	gtk_init(&argc, &argv);

	// deal user settings
	get_user_settings();

	// create main window
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), PACKAGE_NAME);
	GdkPixbuf *icon = gdk_pixbuf_new_from_file(ICONDIR G_DIR_SEPARATOR_S PACKAGE ".png", NULL);
	gtk_window_set_icon(GTK_WINDOW(window), icon);
	if (icon) g_object_unref(icon);

	// close application if [Close Button] clicked
	g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(main_quit), NULL);
	g_signal_connect_after(G_OBJECT(window), "focus-in-event", G_CALLBACK(window_get_focuse), NULL);
	g_signal_connect(G_OBJECT(window), "focus-out-event", G_CALLBACK(window_lost_focuse), NULL);
	g_signal_connect(G_OBJECT(window), "style-set", G_CALLBACK(window_style_set), NULL);
//	g_signal_connect_after(G_OBJECT(window), "size-allocate", G_CALLBACK(window_size_allocate), NULL);
//	g_signal_connect(G_OBJECT(window), "size-request", G_CALLBACK(window_size_request), NULL);
//	g_signal_connect(G_OBJECT(window), "activate-default", G_CALLBACK(window_activate_default), NULL);
//	g_signal_connect(G_OBJECT(window), "activate-focus", G_CALLBACK(window_activate_focus), NULL);
//	g_signal_connect(G_OBJECT(window), "frame-event", G_CALLBACK(window_frame_event), NULL);
//	g_signal_connect(G_OBJECT(window), "set-focus", G_CALLBACK(window_set_focus), NULL);
//	g_signal_connect(G_OBJECT(window), "configure-event", G_CALLBACK(window_configure), NULL);

	// create notebook
	notebook = gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
	gtk_container_add(GTK_CONTAINER(window), notebook);
#ifdef ENABLE_TAB_REORDER
	g_signal_connect(G_OBJECT(notebook), "page-reordered", G_CALLBACK(reorder_page_number), NULL);
#endif
	// add a new page to notebook. run_once=TRUE.
	add_page(1);

	// finish!
	gtk_widget_show_all(window);

	// create menu
	// input method menu can't not be shown before windows is shown.
	create_menu();

	gtk_main();

	return 0;
}

void window_get_focuse(GtkWidget *window, gpointer user_data)
{
	// g_debug("! window_get_focuse!\n");
	if (current_vtebox!=NULL && force_resize_window==0)
		window_resizable(window, current_vtebox, 0, -1);
	else
	{
		// g_debug("No, We will not resize window!\n");
		force_resize_window--;
	}
}

void window_lost_focuse(GtkWidget *window, gpointer user_data)
{
	// g_debug("! window_lost_focuse!\n");
	if (current_vtebox!=NULL)
		window_resizable(window, current_vtebox, 0, 1);
}

void window_style_set (GtkWidget *widget, GtkStyle  *previous_style, gpointer user_data)
{
	// g_debug("! window_style_set!\n");
	if (current_vtebox!=NULL)
		window_resizable(window, current_vtebox, 0, -1);
}

//void window_size_allocate(GtkWindow *window, GtkWidget *widget, gpointer user_data)
//{
//	g_debug("window_size-allocate!\n");
//	//if (current_vtebox!=NULL)
//	//	window_resizable(window, current_vtebox, 0, -1);
//}
//
//void window_size_request(GtkWindow *window, GtkWidget *widget, gpointer user_data)
//{
//	g_debug("window_size-request!\n");
//	//if (current_vtebox!=NULL)
//	//	window_resizable(window, current_vtebox, 0, 1);
//}
//// The "activate-default" signal
//void window_activate_default (GtkWindow *window, gpointer user_data)
//{
//	g_debug("activate-default\n");
//}
//
//// The "activate-focus" signal
//void window_activate_focus (GtkWindow *window, gpointer user_data)
//{
//	g_debug("activate-focus\n");
//}
//
//// The "frame-event" signal
//gboolean  window_frame_event (GtkWindow *window, GdkEvent  *event, gpointer user_data)
//{
//	g_debug("frame-event\n");
//	return TRUE;
//}
//
//// The "set-focus" signal
//void window_set_focus (GtkWindow *window, GtkWidget *widget, gpointer user_data)
//{
//	g_debug("set-focus\n");
//}
//
//// The "configure-event" signal
//
//gboolean window_configure (GtkWidget *widget, GdkEventConfigure *event, gpointer user_data)
//{
//	g_debug("configure\n");
//	return TRUE;
//}

gboolean main_quit ()
{
	gint total_page = gtk_notebook_get_n_pages(GTK_NOTEBOOK(notebook));
	if (total_page>1)
	{
		dialog(NULL, 3);
	}
	else
		close_page(NULL, TRUE);
	// It will be segmentation fault if retrun FALSE
	return TRUE;
}

void command_option(int  *argc,
		    char *argv[])
{
	gint i;
	for (i=0;i<*argc;i++)
	{
		// g_debug("%2d (Total %d): %s\n",i, *argc, argv[i]);
		if ((!strcmp(argv[i], "-v")) || (!strcmp(argv[i], "--version")))
		{
			g_print("%s %s\n", PACKAGE_NAME, VERSION);
			exit (0);
		}
		else if ((!strcmp(argv[i], "-h")) || (!strcmp(argv[i], "--help")))
		{
			g_print(got_help_message());
			exit (0);
		}
		else if ((!strcmp(argv[i], "-p")) || (!strcmp(argv[i], "--profile")))
		{
			g_print(got_profile_sample());
			exit (0);
		}
		else if ((!strcmp(argv[i], "-e")) || (!strcmp(argv[i], "--execute")))
		{
			if (++i==*argc)
				g_debug("Missing command after -e/--execute option!\n");
			else
			{
				command_line = argv[i];
				parameter = &(argv[i]);
				// g_debug("Command = %s %s\n", command_line, *parameter);
			}
		}
		else if ((!strcmp(argv[i], "-u")) || (!strcmp(argv[i], "--user_profile")))
		{
			if (++i==*argc)
				g_debug("Missing file name after -u/--user_profile!\n");
			else
			{
				//gint j;
				//for (j=i+1;j<*argc;j++)
				//	*(argv[j]-1) = ' ';
				//*argc = i+1;
				profile = g_strdup(argv[i]);
			}
			g_debug ("Using Profile = %s", profile);

			//for (j=0;j<*argc;j++)
			//	g_debug("%2d (Total %d): %s\n",j, *argc, argv[j]);
		}
	}
	if (profile==NULL)
	{
		profile = g_strdup_printf("%s/%s", g_get_user_config_dir(), RCFILE);
		// g_debug("Trying to use user's profile %s...\n", profile);
		if ( ! g_file_test(profile , G_FILE_TEST_EXISTS))
		{
			// g_debug("Can not find user's profile. trying system profile...\n");
			g_free(profile);
			const char * const *system_dirs = g_get_system_config_dirs();
			for (i=0; system_dirs[i] != NULL; i++)
			{
				profile = g_strdup_printf("%s/%s", system_dirs[i], RCFILE);
				// g_debug("Trying to use %s...\n", profile);
				if ( g_file_test(profile , G_FILE_TEST_EXISTS))
					break;
				else
				{
					g_free(profile);
					profile = NULL;
				}
			}
			//if (profile==NULL)
			//	g_debug("Sorry, can not find any profile. use program defaults.\n");
		}
	}
}

gchar *got_help_message()
{
	GString *help_message;
	gint j;
	const char * const *system_dirs = g_get_system_config_dirs();
	
	help_message = g_string_new("");
	g_string_append_printf( help_message,	 
					_("%s is a libvte based X Terminal Emulater.\n\n"), PACKAGE_NAME);
	g_string_append_printf( help_message,	 
					_("Use -e/--execute {Command} to run a command after %s start.\n"), PACKAGE_NAME);
	g_string_append( help_message,	_("Use -v/--version to show the version infomation.\n"));
	g_string_append( help_message,	_("Use -p/--profile to got a profile sample.\n"));
	g_string_append_printf( help_message,	 
					_("Use -u/--user_profile {%s} to use a specified profile.\n\n"), RCFILE);
	for (j=0; system_dirs[j] != NULL; j++)
		g_string_append_printf( help_message,
					_("The %s system config is: %s/%s\n"), PACKAGE_NAME, system_dirs[j], RCFILE);
	g_string_append_printf( help_message,	 
					_("And your %s profile is: %s/%s\n\n"),
								PACKAGE_NAME, g_get_user_config_dir(), RCFILE);
	g_string_append( help_message,	_("Default shortcut key: (It may custom by editing user's profile)\n\n"));
	g_string_append( help_message,	_("  * <Ctrl><T>\t\tNew tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><W>\t\tClose current tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><E>\t\tRename current tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><PageUp>\tSwitch to prev tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><PageDown>\tSwitch to next tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><Home>\tSwitch to first tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><End>\t\tSwitch to last tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><Left>\tMove current page forward\n"));
	g_string_append( help_message,	_("  * <Ctrl><Right>\tMove current page backward\n"));
	g_string_append( help_message,	_("  * <Ctrl><Up>\t\tMove current page to first\n"));
	g_string_append( help_message,	_("  * <Ctrl><Down>\tMove current page to last\n"));
	g_string_append( help_message,	_("  * <Ctrl><F1~F12>\tSwitch to 1st ~ 12th tab\n"));
	g_string_append( help_message,	_("  * <Ctrl><O>\t\tSelect all the text in the Vte Terminal box\n"));
	g_string_append( help_message,	_("  * <Ctrl><X>\t\tCopy the text to clipboard\n"));
	g_string_append( help_message,	_("  * <Ctrl><V>\t\tPast the text in clipboard\n"));
	g_string_append( help_message,	_("  * <Ctrl><+>\t\tIncrease font size\n"));
	g_string_append( help_message,	_("  * <Ctrl><->\t\tDecrease font size\n"));
	g_string_append( help_message,	_("  * <Ctrl><Enter>\tReset font_size\n"));
	g_string_append( help_message,	_("  * <Shift><Insert>\tPast the text in primary clipboard\n"));
	g_string_append( help_message,	_("\t\t\t(Emulate a middle button mouse click to past the text)\n\n"));
	g_string_append_printf( help_message,	
					_("Please report bug to %s. Thank you for using %s!\n"),
								PACKAGE_BUGREPORT, PACKAGE);
	return help_message->str;
}

gchar *got_profile_sample()
{
	return g_strdup("[main]\n"
			"page_name = Terminal\n"
			"page_names = Terminal\n"
			"reuse_page_names = 1\n"
			"page_number = 1\n"
			"page_shows_current_cmdline = 1\n"
			"window_shows_current_page = 1\n"
			"foreground_color = white\n"
			"background_color = black\n"
			"font_name = Monospace 15\n"
			"screen_width = 80\n"
			"screen_height = 25\n"
			"transparent_background = 0\n"
			"background_saturation = 0.2\n"
			"word_chars = -A-Za-z0-9_$.+!*(),;:@&=?/~#%[]\n"
			"scrollback_lines = 1024\n"
			"show_input_method_menu = 0\n"
			"locales_list = EUC-JP GB2312 Big5\n"
			"\n"
			"[key]\n"
			"new_tab_key = Ctrl T\n"
			"close_tab_key = Ctrl W\n"
			"edit_label_key = Ctrl E\n"
			"prev_tab_key = Ctrl Page_Up\n"
			"next_tab_key = Ctrl Page_Down\n"
			"first_tab_key = Ctrl Home\n"
			"last_tab_key = Ctrl End\n"
			"move_tab_forward = Ctrl Left\n"
			"move_tab_backward = Ctrl Right\n"
			"move_tab_first = Ctrl Up\n"
			"move_tab_last = Ctrl Down\n"
			"swith_to_tab_1 = Ctrl F1\n"
			"swith_to_tab_2 = Ctrl F2\n"
			"swith_to_tab_3 = Ctrl F3\n"
			"swith_to_tab_4 = Ctrl F4\n"
			"swith_to_tab_5 = Ctrl F5\n"
			"swith_to_tab_6 = Ctrl F6\n"
			"swith_to_tab_7 = Ctrl F7\n"
			"swith_to_tab_8 = Ctrl F8\n"
			"swith_to_tab_9 = Ctrl F9\n"
			"swith_to_tab_10 = Ctrl F10\n"
			"swith_to_tab_11 = Ctrl F11\n"
			"swith_to_tab_12 = Ctrl F12\n"
			"increase_font_size = Ctrl equal\n"
			"decrease_font_size = Ctrl minus\n"
			"reset_font_size = Ctrl Return\n"
			"select_all = Ctrl O\n"
			"copy_clipboard = Ctrl X\n"
			"past_clipboard = Ctrl V\n");
}
