#!/bin/bash
export LC_ALL=C
COUNTDATA="$HOME/.gcin/statistic/gcin_word_count_`date +%Y%m%d_%a`"
RAWIMG="$HOME/.gcin/gcin_keyboard.png"   #圖片檔，可自行更換
OUTIMG="/tmp/_gcin_count.png"
POS_X=38  #數字離左側邊緣的距離
POS_Y=2    #數字離上方邊緣的距離
FONT_SIZE=18   #字型大小
INTERVAL=1
IFS=


read -r aa
echo -n $aa

touch $COUNTDATA
declare -i count=`cat $COUNTDATA`
declare -i len=` echo -n $aa | python -c "import sys;a=sys.stdin.readlines();s=unicode(a[0], \"utf-8\");print len(s)"`

declare -i mod_a=$count%$INTERVAL
let count=$count+$len
declare -i mod_b=$count%$INTERVAL

echo $count > $COUNTDATA

function pop_img {
  convert $RAWIMG -pointsize $FONT_SIZE -draw "gravity northwest fill black text $POS_X,$POS_Y '$count'" $OUTIMG
  gcin-message -icon $OUTIMG -duration 3000    #這個數值為顯示的時間長度，以毫秒為單位，可視需要修改
}

if [ $mod_a -gt $mod_b ] ; then
  pop_img ;
elif [ $mod_a -eq $mod_b ] && [ $len -gt 0 ]; then # interval == len
  pop_img ;
fi

exit 0

